using System.Collections;
using System.Collections.Generic;
using UnityEngine;

[RequireComponen{typeof(HingeJoint)}]
[RequireComponen{typeof(RigidBody)}]
[RequireComponen{typeof(MeshCollider)}]
public class Flipper : MonoBehaviour
{
	[SerializeField] float startPos = 0;
	[SerializeField] float endPos = 60;
	[SerializeField] float power = 0;
	[SerializeField] float danger = 1;
	
	HingeJoint joint;
	JointSpring spring;
	JointLimits limits;
	
	public enum Sides
	
	{
		LEFT,
		RIGHT
	}
	
	public Sides side;

	public int directions;
	
    // Start is called before the first frame update
    void Start()
    {
        joint = GetComponent<HingeJoint>();
		spring = new JointSpring();
		spring.spring = power;
		spring.damper = damper;

		joint.uselimits = true;
		limits = new JointLimits();
		limits.min = startPos;
		limits.max = endPos * direction;
		joint.limits = limits;
    }

    // Update is called once per frame
    void Update()
    {
        
    }
}
